package jadean.ui.java.handlers;

import jadean.dean.java.JavaProject;
import jadean.ui.handlers.DependencyAnalyzerHandler;
import jadean.ui.java.wizards.DependencyAnalyzerWizard;
import jadean.ui.java.wizards.WizardInput;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.PlatformUI;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;


public class JavaDependencyAnalyzerHandler implements DependencyAnalyzerHandler {

	public Object handle(Object projectElement) {
		try {
			WizardInput wizardInput = new WizardInput();
			IJavaProject project = HandlerUtilities.getJavaProject(projectElement);
			if (project == null) {
				return null;
			}
			
			String name = project.getElementName();
			String outputFolder = HandlerUtilities.getJavaOutputFolder(project);
			String[] sourceFolders = HandlerUtilities.getJavaSourceFolders(project);
			String[] referencedPackages = HandlerUtilities.getJavaReferencedPackages(project);
			
			JavaProject javaProject = new JavaProject(name, sourceFolders, outputFolder, referencedPackages);

			WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), new DependencyAnalyzerWizard(wizardInput));
			
			wizardInput.setProject(javaProject);
			wizardInput.notifyListeners();

			dialog.create();
			dialog.setBlockOnOpen(true);
			if (dialog.open() == Window.OK) {
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

}
